struct VS_INPUT // FVF 2
{
    float4 Position   : POSITION;
};

struct VS_OUTPUT
{
    float4 Position 	: POSITION;
    float2 TexCoord		: TEXCOORD0;
};

float4x4 World : WORLD;
float4x4 View : VIEW;
float4x4 Proj : PROJECTION;

sampler2D Tex0 : register( s0 );
float4x4 TexTx0 : TEXTX0;

float4 TFactor : TFACTOR;

float TextureSize;

VS_OUTPUT vs_main(in VS_INPUT In)
{
    VS_OUTPUT Out;
	float4 viewPos = mul( mul(In.Position, World), View);
    Out.Position = mul(viewPos, Proj);
	Out.TexCoord = mul(viewPos, TexTx0).xy; // generated from view position
	return Out;
}

float4 ps_main(in VS_OUTPUT In) : COLOR
{
	float4 Color;
	
	float2 d = float2( 1/ TextureSize, -1/ TextureSize);
	
	float c = 0;
	c += tex2D( Tex0, In.TexCoord + d.xx ).x;
	c += tex2D( Tex0, In.TexCoord + d.yx ).x;
	c += tex2D( Tex0, In.TexCoord ).x * 2;
	c += tex2D( Tex0, In.TexCoord + d.xy ).x;
	c += tex2D( Tex0, In.TexCoord + d.yy ).x;
	c /= 6;
	
	return float4(TFactor.rgb + (1 - TFactor.rgb)*c, c);
}

technique GroundShadow
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main();
		PixelShader = compile ps_3_0 ps_main();
	}
}